/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.rcx.materialis.datagen.MaterialisBlockTags;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class WrenchingModifier
extends NoLevelsModifier {
    private final int priority;

    public WrenchingModifier(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    public InteractionResult beforeBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        if (!tool.isBroken() && context.m_43723_() != null) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            if (state.m_60750_(context.m_43725_(), context.m_8083_()) != null || world.m_7702_(pos) != null) {
                return this.blockUse(tool, level, world, pos, state, context);
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult afterBlockUse(IToolStackView tool, int level, UseOnContext context, EquipmentSlot slot) {
        if (!tool.isBroken() && context.m_43723_() != null) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            if (state.m_60750_(context.m_43725_(), context.m_8083_()) == null && world.m_7702_(pos) == null) {
                return this.blockUse(tool, level, world, pos, state, context);
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult blockUse(IToolStackView tool, int level, Level world, BlockPos pos, BlockState state, UseOnContext context) {
        if (context.m_43723_().m_36341_() || !state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, (Entity)context.m_43723_()) || !TierSortingRegistry.isCorrectTierForDrops((Tier)((Tier)tool.getStats().get((IToolStat)ToolStats.HARVEST_TIER)), (BlockState)state) || !WrenchingModifier.isRotatable(state, world, pos)) {
            return InteractionResult.PASS;
        }
        Direction face = context.m_43719_();
        Rotation rotation = context.m_43719_().m_122421_() == Direction.AxisDirection.POSITIVE ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
        for (Property prop : state.m_61147_()) {
            Half half;
            BlockState newState;
            RailShape shape;
            RailShape newShape;
            Direction.Axis axis;
            Direction.Axis newAxis;
            BlockState newState2;
            Direction direction;
            Direction newDirection;
            if (prop instanceof DirectionProperty && (newDirection = WrenchingModifier.rotateDirection(direction = (Direction)state.m_61143_((Property)((DirectionProperty)prop)), face.m_122434_(), rotation)) != direction) {
                newState2 = null;
                boolean success = false;
                for (int attempts = 0; attempts < 3; ++attempts) {
                    if (prop.m_6908_().contains(newDirection) && (newState2 = (BlockState)state.m_61124_((Property)((DirectionProperty)prop), (Comparable)newDirection)).m_60710_((LevelReader)world, pos)) {
                        success = true;
                        break;
                    }
                    newDirection = WrenchingModifier.rotateDirection(newDirection, face.m_122434_(), rotation);
                }
                if (success) {
                    world.m_7731_(pos, newState2, 11);
                    ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
                    return InteractionResult.SUCCESS;
                }
            }
            if ((prop == BlockStateProperties.f_61365_ || prop == BlockStateProperties.f_61364_) && (newAxis = WrenchingModifier.rotateAxis(axis = prop == BlockStateProperties.f_61365_ ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_) : (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_), face.m_122434_(), rotation)) != axis && prop.m_6908_().contains(newAxis) && (newState2 = prop == BlockStateProperties.f_61365_ ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)newAxis) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)newAxis)).m_60710_((LevelReader)world, pos)) {
                world.m_7731_(pos, newState2, 11);
                ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
                return InteractionResult.SUCCESS;
            }
            if ((prop == BlockStateProperties.f_61403_ || prop == BlockStateProperties.f_61404_) && (newShape = this.rotateRail(shape = prop == BlockStateProperties.f_61403_ ? (RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_) : (RailShape)state.m_61143_((Property)BlockStateProperties.f_61404_), face.m_122434_(), rotation)) != shape) {
                if (WrenchingModifier.shouldRailBeRemoved(pos, world, newShape)) {
                    newShape = this.rotateRail(shape, face.m_122434_(), rotation.m_55952_(Rotation.CLOCKWISE_180));
                }
                if (!WrenchingModifier.shouldRailBeRemoved(pos, world, newShape) && prop.m_6908_().contains(newShape)) {
                    newState2 = prop == BlockStateProperties.f_61403_ ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)newShape) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)newShape);
                    world.m_7731_(pos, newState2, 11);
                    ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
                    return InteractionResult.SUCCESS;
                }
            }
            if (prop == BlockStateProperties.f_61390_) {
                int rotation16 = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
                rotation16 = (rotation16 + 1) % 16;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rotation16)), 11);
                ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
                return InteractionResult.SUCCESS;
            }
            if (prop == BlockStateProperties.f_61402_ && (newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(half = (half = (Half)state.m_61143_((Property)BlockStateProperties.f_61402_)) == Half.TOP ? Half.BOTTOM : Half.TOP))).m_60710_((LevelReader)world, pos)) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)half), 11);
                ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
                return InteractionResult.SUCCESS;
            }
            if (prop != BlockStateProperties.f_61397_ || (half = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)) == SlabType.DOUBLE || !(newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)(half = half == SlabType.TOP ? SlabType.BOTTOM : SlabType.TOP))).m_60710_((LevelReader)world, pos)) continue;
            world.m_7731_(pos, newState, 11);
            ToolDamageUtil.damage((IToolStackView)tool, (int)1, (LivingEntity)context.m_43723_(), (ItemStack)context.m_43722_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Direction rotateDirection(Direction direction, Direction.Axis rotateOn, Rotation rotation) {
        if (direction.m_122434_() == rotateOn) {
            return direction;
        }
        switch (rotation) {
            case CLOCKWISE_180: {
                return direction.m_122424_();
            }
            case COUNTERCLOCKWISE_90: {
                switch (rotateOn) {
                    case X: {
                        switch (direction) {
                            case DOWN: {
                                return Direction.NORTH;
                            }
                            case UP: {
                                return Direction.SOUTH;
                            }
                            case NORTH: {
                                return Direction.UP;
                            }
                            case SOUTH: {
                                return Direction.DOWN;
                            }
                        }
                        return direction;
                    }
                    case Y: {
                        switch (direction) {
                            case NORTH: {
                                return Direction.WEST;
                            }
                            case SOUTH: {
                                return Direction.EAST;
                            }
                            case WEST: {
                                return Direction.SOUTH;
                            }
                            case EAST: {
                                return Direction.NORTH;
                            }
                        }
                        return direction;
                    }
                    case Z: {
                        switch (direction) {
                            case DOWN: {
                                return Direction.EAST;
                            }
                            case UP: {
                                return Direction.WEST;
                            }
                            case WEST: {
                                return Direction.DOWN;
                            }
                            case EAST: {
                                return Direction.UP;
                            }
                        }
                        return direction;
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (rotateOn) {
                    case X: {
                        switch (direction) {
                            case DOWN: {
                                return Direction.SOUTH;
                            }
                            case UP: {
                                return Direction.NORTH;
                            }
                            case NORTH: {
                                return Direction.DOWN;
                            }
                            case SOUTH: {
                                return Direction.UP;
                            }
                        }
                        return direction;
                    }
                    case Y: {
                        switch (direction) {
                            case NORTH: {
                                return Direction.EAST;
                            }
                            case SOUTH: {
                                return Direction.WEST;
                            }
                            case WEST: {
                                return Direction.NORTH;
                            }
                            case EAST: {
                                return Direction.SOUTH;
                            }
                        }
                        return direction;
                    }
                    case Z: {
                        switch (direction) {
                            case DOWN: {
                                return Direction.WEST;
                            }
                            case UP: {
                                return Direction.EAST;
                            }
                            case WEST: {
                                return Direction.UP;
                            }
                            case EAST: {
                                return Direction.DOWN;
                            }
                        }
                        return direction;
                    }
                }
            }
        }
        return direction;
    }

    public static Direction.Axis rotateAxis(Direction.Axis axis, Direction.Axis rotateOn, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return axis;
            }
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (rotateOn) {
                    case X: {
                        switch (axis) {
                            case Y: {
                                return Direction.Axis.Z;
                            }
                            case Z: {
                                return Direction.Axis.Y;
                            }
                        }
                        return axis;
                    }
                    case Y: {
                        switch (axis) {
                            case X: {
                                return Direction.Axis.Z;
                            }
                            case Z: {
                                return Direction.Axis.X;
                            }
                        }
                        return axis;
                    }
                    case Z: {
                        switch (axis) {
                            case X: {
                                return Direction.Axis.Y;
                            }
                            case Y: {
                                return Direction.Axis.X;
                            }
                        }
                        return axis;
                    }
                }
            }
        }
        return axis;
    }

    public RailShape rotateRail(RailShape shape, Direction.Axis rotateOn, Rotation rotation) {
        switch (rotateOn) {
            case Y: {
                switch (rotation) {
                    case CLOCKWISE_180: {
                        switch (shape) {
                            case ASCENDING_EAST: {
                                return RailShape.ASCENDING_WEST;
                            }
                            case ASCENDING_WEST: {
                                return RailShape.ASCENDING_EAST;
                            }
                            case ASCENDING_NORTH: {
                                return RailShape.ASCENDING_SOUTH;
                            }
                            case ASCENDING_SOUTH: {
                                return RailShape.ASCENDING_NORTH;
                            }
                            case SOUTH_EAST: {
                                return RailShape.NORTH_WEST;
                            }
                            case SOUTH_WEST: {
                                return RailShape.NORTH_EAST;
                            }
                            case NORTH_WEST: {
                                return RailShape.SOUTH_EAST;
                            }
                            case NORTH_EAST: {
                                return RailShape.SOUTH_WEST;
                            }
                            case NORTH_SOUTH: 
                            case EAST_WEST: {
                                return shape;
                            }
                        }
                    }
                    case COUNTERCLOCKWISE_90: {
                        switch (shape) {
                            case ASCENDING_EAST: {
                                return RailShape.ASCENDING_NORTH;
                            }
                            case ASCENDING_WEST: {
                                return RailShape.ASCENDING_SOUTH;
                            }
                            case ASCENDING_NORTH: {
                                return RailShape.ASCENDING_WEST;
                            }
                            case ASCENDING_SOUTH: {
                                return RailShape.ASCENDING_EAST;
                            }
                            case SOUTH_EAST: {
                                return RailShape.NORTH_EAST;
                            }
                            case SOUTH_WEST: {
                                return RailShape.SOUTH_EAST;
                            }
                            case NORTH_WEST: {
                                return RailShape.SOUTH_WEST;
                            }
                            case NORTH_EAST: {
                                return RailShape.NORTH_WEST;
                            }
                            case NORTH_SOUTH: {
                                return RailShape.EAST_WEST;
                            }
                            case EAST_WEST: {
                                return RailShape.NORTH_SOUTH;
                            }
                        }
                    }
                    case CLOCKWISE_90: {
                        switch (shape) {
                            case ASCENDING_EAST: {
                                return RailShape.ASCENDING_SOUTH;
                            }
                            case ASCENDING_WEST: {
                                return RailShape.ASCENDING_NORTH;
                            }
                            case ASCENDING_NORTH: {
                                return RailShape.ASCENDING_EAST;
                            }
                            case ASCENDING_SOUTH: {
                                return RailShape.ASCENDING_WEST;
                            }
                            case SOUTH_EAST: {
                                return RailShape.SOUTH_WEST;
                            }
                            case SOUTH_WEST: {
                                return RailShape.NORTH_WEST;
                            }
                            case NORTH_WEST: {
                                return RailShape.NORTH_EAST;
                            }
                            case NORTH_EAST: {
                                return RailShape.SOUTH_EAST;
                            }
                            case NORTH_SOUTH: {
                                return RailShape.EAST_WEST;
                            }
                            case EAST_WEST: {
                                return RailShape.NORTH_SOUTH;
                            }
                        }
                    }
                }
                return shape;
            }
            case X: {
                switch (rotation) {
                    case CLOCKWISE_90: {
                        switch (shape) {
                            case ASCENDING_NORTH: {
                                return RailShape.NORTH_SOUTH;
                            }
                            case ASCENDING_SOUTH: {
                                return RailShape.NORTH_SOUTH;
                            }
                            case NORTH_SOUTH: {
                                return RailShape.ASCENDING_NORTH;
                            }
                        }
                        return shape;
                    }
                    case COUNTERCLOCKWISE_90: {
                        switch (shape) {
                            case ASCENDING_NORTH: {
                                return RailShape.NORTH_SOUTH;
                            }
                            case ASCENDING_SOUTH: {
                                return RailShape.NORTH_SOUTH;
                            }
                            case NORTH_SOUTH: {
                                return RailShape.ASCENDING_SOUTH;
                            }
                        }
                        return shape;
                    }
                }
                return shape;
            }
            case Z: {
                switch (rotation) {
                    case CLOCKWISE_90: {
                        switch (shape) {
                            case ASCENDING_EAST: {
                                return RailShape.EAST_WEST;
                            }
                            case ASCENDING_WEST: {
                                return RailShape.EAST_WEST;
                            }
                            case EAST_WEST: {
                                return RailShape.ASCENDING_EAST;
                            }
                        }
                        return shape;
                    }
                    case COUNTERCLOCKWISE_90: {
                        switch (shape) {
                            case ASCENDING_EAST: {
                                return RailShape.EAST_WEST;
                            }
                            case ASCENDING_WEST: {
                                return RailShape.EAST_WEST;
                            }
                            case EAST_WEST: {
                                return RailShape.ASCENDING_WEST;
                            }
                        }
                        return shape;
                    }
                }
                return shape;
            }
        }
        return shape;
    }

    public static boolean isRotatable(BlockState state, Level world, BlockPos pos) {
        if (pos.m_123342_() >= 0 && pos.m_123342_() <= world.m_151558_() - 1 && world.m_6857_().m_61937_(pos)) {
            Collection properties = state.m_61147_();
            if (state.m_204336_(MaterialisBlockTags.WRENCH_BLACKLIST)) {
                return false;
            }
            if (properties.contains(BlockStateProperties.f_61401_)) {
                return false;
            }
            if (properties.contains(BlockStateProperties.f_61391_)) {
                return false;
            }
            if (properties.contains(BlockStateProperties.f_61392_) && state.m_61143_((Property)BlockStateProperties.f_61392_) != ChestType.SINGLE) {
                return false;
            }
            return !properties.contains(BlockStateProperties.f_61432_) || (Boolean)state.m_61143_((Property)BlockStateProperties.f_61432_) == false;
        }
        return false;
    }

    public static boolean shouldRailBeRemoved(BlockPos pos, Level world, RailShape shape) {
        if (!Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_7495_())) {
            return true;
        }
        switch (shape) {
            case ASCENDING_EAST: {
                return !Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_142126_());
            }
            case ASCENDING_WEST: {
                return !Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_142125_());
            }
            case ASCENDING_NORTH: {
                return !Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_142127_());
            }
            case ASCENDING_SOUTH: {
                return !Block.m_49936_((BlockGetter)world, (BlockPos)pos.m_142128_());
            }
        }
        return false;
    }
}

